<?php
require 'vendor/autoload.php';  // Incluye el autoloader de PhpSpreadsheet

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Obtén los parámetros de la URL
$tipoServicios = $_GET['tipoServicios'];
$estadoServicios = $_GET['estadoServicios'];
$zonaBloques = $_GET['zonaBloques'];

// Aquí se consulta a la base de datos para obtener los datos. Asegúrate de usar tu implementación específica.
require_once "controladores/servicios.controlador.php";
require_once "modelos/servicios.modelo.php";

$datos = ControladorServicios::ctrMostrarporBloques($item, $tipoServicios, $estadoServicios, $zonaBloques);

// Crea una nueva hoja de cálculo
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Define el contenido de la hoja Excel
$sheet->setCellValue('A1', '#');
$sheet->setCellValue('B1', 'BLOQUE');
$sheet->setCellValue('C1', 'DIPLOMADO');
$sheet->setCellValue('D1', 'TOTAL DE INSCRITOS');
$sheet->setCellValue('E1', 'ALUMNOS EN LISTA');
$sheet->setCellValue('F1', 'MONTO TOTAL');
$sheet->setCellValue('G1', 'MONTO COBRADO');
$sheet->setCellValue('H1', 'MONTO POR RECUPERAR');
$sheet->setCellValue('I1', 'MONTO ATRASADO');
$sheet->setCellValue('J1', 'PERDIDO POR BAJAS');
$sheet->setCellValue('K1', 'COMPLETADO');
$sheet->setCellValue('L1', 'ACTIVO');
$sheet->setCellValue('M1', 'ATRASADO');
$sheet->setCellValue('N1', 'BAJAS');

// Llena la hoja de cálculo con datos
$rowNumber = 2; // Empieza a llenar desde la segunda fila
foreach ($datos as $index => $row) {
    $sheet->setCellValue('A'.$rowNumber, $index + 1);
    $sheet->setCellValue('B'.$rowNumber, $row['BLOQUE']);
    $sheet->setCellValue('C'.$rowNumber, $row['DIPLOMADO']);
    $sheet->setCellValue('D'.$rowNumber, $row['TOTAL_INSCRITOS']);
    $sheet->setCellValue('E'.$rowNumber, $row['ALUMNOS ACTIVOS']);
    $sheet->setCellValue('F'.$rowNumber, $row['MONTO TOTAL']);
    $sheet->setCellValue('G'.$rowNumber, $row['MONTO_COBRADO']);
    $sheet->setCellValue('H'.$rowNumber, $row['MONTO_POR_RECUPERAR']);
    $sheet->setCellValue('I'.$rowNumber, $row['MONTO_ATRASADO']);
    $sheet->setCellValue('J'.$rowNumber, $row['PERDIDO_POR_BAJAS']);
    $sheet->setCellValue('K'.$rowNumber, $row['COMPLETADO']);
    $sheet->setCellValue('L'.$rowNumber, $row['ACTIVO']);
    $sheet->setCellValue('M'.$rowNumber, $row['ATRASADO']);
    $sheet->setCellValue('N'.$rowNumber, $row['BAJAS']);
    $rowNumber++;
}

// Genera el archivo Excel y envíalo al navegador
$writer = new Xlsx($spreadsheet);

// Establecer el encabezado para forzar la descarga
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="reporte_recuperacion.xlsx"');
header('Cache-Control: max-age=0');

$writer->save('php://output');
exit;